# turnkey aliases used by various ECMC bash and sh scripts 
# this file should be sourced automatically on login
# see also turnkey.csh for tcsh and csh shells
# 
# -----------------------------------------------------------------
#  VARIABLES THAT OFTEN NEED TO BE EDITED/CHANGED ON LOCAL SYSTEMS:
#  (other variables below, particular those dealing with cd devices,
#  also may need to be edited)
export TURNKEY=/usr/local/turnkey  # path where Turnkey is installed
export CSDIR=/usr/bin  # directory where all csound binaries are installed
 # most package managers, like apt-get, place Csound binaries in /usr/bin
# variables for cdrecord
export CDR_DEVICE=ATAPI:0,0,0  # device scsi ID -- get from cdrecord -scanbus
export CDROM=/dev/cdrom
export CDR_SPEED=40 # highest speed for cdr recording; 40 for Plextor 708A
alias  levels='/usr/bin/envy24control > /dev/null' # set to soundcard GUI
# -----------------------------------------------------------------
# --- set up basic environment variables and paths  ---
#
export MACHINE='HOSTNAME'               # set to name of machine
export SYSTYPE=LINUX                    # set to LINUX or OSX
export LINUX_HOST=digital.music.cornell.edu
export MANPATH="`manpath`:/usr/local/turnkey/cslib/man" # add cslib/man to man path
#export HOME_SFDIR=/snd/`whoami`
#export SFDIR=/snd/`whoami`
export HOME_SFDIR=/snd/`whoami`
export SFDIR=/snd/`whoami`
export OLDSFDIR=/snd/`whoami`
export SFDIRBASE=`basename $SFDIR`
export PS1="[\u@\h \W | \$SFDIRBASE]\$ "

export SFLIB=/snd/sflib
export SFLIB96=/snd/sflib96
#
export CSLIBDIR=$TURNKEY/cslib  # path to Eastman Csound Library, formerly called olib
   # needed for PVC templates/examples
export PVCBIN=/usr/bin
export PVCDIR=$TURNKEY/pvc
   # needed for sms templates/examples
export SMSDIR=$TURNKEY/sms
export SMSXDIR=$TURNKEY/sms/X
   # needed for vspace templates/examples
export VSPACEDIR=$TURNKEY/vspace
export VSPACEXDIR=$TURNKEY/vspace/X
# Default command-line player
export DEFAULT_PLAYER=sndplay
# Application rescource files
export XAPPLRESDIR=/etc/X11/app-defaults
export TMPDIR=/tmp
export HTML=firefox
export EDIT=/usr/local/bin/sweep
export TEXT="open -e"
export PLAY=/usr/local/bin/play
#
export LANG=en_US.iso88591  # default US English

# LADSPA plugin path, needed for PD "plugin~" object and others
export LADSPA_PATH=/usr/lib/ladspa

## GUIDELINES FOR BASH FUNCTIONS:  
##  function foosf { (cd $SFDIR; /usr/bin/foo $@) }  
#OR  foosf() { (cd $SFDIR; /usr/bin/foo $@) }  ... former is preferable
#  $@ is better than $* for argument grouping.
#  If an environment variable is to be exported, obviously the inner parentheses must be left out of the above formulation because of the subshell they open... see cdsf 
# the subshell formulation is better in most cases because it will not interfere with user variables like $OLDPWD for "cd -"  et cetera;  subshell functions need not end with a semicolon, but "naked" curly brace functions do - compare cdsf and lsf

#function fcdsf { shopt -u -o noglob;  declare TEMP_CWD=`pwd`; declare TEMP_OLDPWD=$OLDPWD; declare PREV_SFDIR=$SFDIR; declare STAT; if [ $# == 0 ]; then cd $HOME_SFDIR; STAT=$?; elif [ "$1" == "-" ]; then cd $OLDSFDIR; STAT=$?; else cd $SFDIR; cd $@; STAT=$?; fi; export SFDIR=`pwd`; if [ $STAT == 0 ]; then export OLDSFDIR=$PREV_SFDIR; fi; cd $TEMP_CWD; export OLDPWD=$TEMP_OLDPWD; return $STAT; }
                                                                                
function fcdsf { shopt -u -o noglob;  declare TEMP_CWD=`pwd`; declare TEMP_OLDPWD=$OLDPWD; declare PREV_SFDIR=$SFDIR; declare STAT; if [ $# == 0 ]; then cd $HOME_SFDIR; STAT=$?; elif [ "$1" == "-" ]; then cd $OLDSFDIR; STAT=$?; else cd $SFDIR; cd $@; STAT=$?; fi; export SFDIR=`pwd`; export SFDIRBASE=`basename $SFDIR`; if [ $STAT == 0 ]; then export OLDSFDIR=$PREV_SFDIR; fi; cd $TEMP_CWD; export OLDPWD=$TEMP_OLDPWD; return $STAT; }
alias cdsf='shopt -s -o noglob; fcdsf'

function  flsf  { shopt -u -o noglob; (cd $SFDIR; ls -h $@) }
alias lsf='shopt -s -o noglob; flsf'
alias lssf='shopt -s -o noglob; flsf'

function   fcpsf  { shopt -u -o noglob; (cd $SFDIR; /bin/cp $@) }
alias cpsf='shopt -s -o noglob; fcpsf'

function   fchmodsf { shopt -u -o noglob; (cd $SFDIR; /bin/chmod $@) }
#alias chmod='shopt -s -o noglob; fchmodsf'
alias chmodsf='shopt -s -o noglob; fchmodsf'

function   ftarsf { shopt -u -o noglob; (cd $SFDIR; /bin/tar $@) }
alias tarsf='shopt -s -o noglob; ftarsf'

function   fmkdirsf { shopt -u -o noglob; (cd $SFDIR; /bin/mkdir $@) }
alias mkdirsf='shopt -s -o noglob; fmkdirsf'

function   fmvsf { shopt -u -o noglob; (cd $SFDIR; /bin/mv $@) }
alias mvsf='shopt -s -o noglob; fmvsf'

function   pwdsf { (cd $SFDIR; /bin/pwd $@) }

function   frmsf { shopt -u -o noglob; (cd $SFDIR; /bin/rm $@) }
alias rmsf='shopt -s -o noglob; frmsf'

function   frmdirsf { shopt -u -o noglob; (cd $SFDIR; /bin/rmdir $@) }
alias rmdirsf='shopt -s -o noglob; frmdirsf'
# alternates to lsex sc, lsex pvc etc.
function   lsexsc { (lsex sc $@) }
function   lsexpvc { (lsex pvc $@) }
function   lsexvs { (lsex vs $@) }
function   lsexsms { (lsex sms $@) }
#
# --- apps and utilities ---
#
function   alsaplayer { (cd $SFDIR; /usr/bin/alsaplayer -x -o jack $@) }
function   mpg123 { (cd $SFDIR; /usr/bin/mpg123 $@) }
function   mpg321 { (cd $SFDIR; /usr/bin/mpg321 $@) }
function   xmms { (cd $SFDIR; /usr/bin/xmms $@) }
#function   rt { (cd $SFDIR; /usr/local/bin/rt $@) }
#alias	rtopen='(/usr/local/bin/rt )'
#alias	openrt='(/usr/local/bin/rt )'
function   mammut { (cd $SFDIR; /usr/bin/mammut $@) }
function   mxv { (cd $SFDIR; /usr/bin/mxv $@) }
function   mixviews  { (cd $SFDIR; /usr/bin/mxv $@) }
function   ceres3 { (cd $SFDIR; /usr/bin/ceres3 4096 4096 128 1200 $@) }
function   sox { (cd $SFDIR; /usr/bin/sox $@) }
function   snd { (cd $SFDIR; /usr/bin/snd $@) }
function   tx { (cd $SFDIR; /usr/bin/terminatorX $@) }
function   audacity { (cd $SFDIR; open /Applications/Audacity/Audacity.app $@) }
function   xplay { (cd $SFDIR; /usr/X11R6/bin/xplay $@) }
function   sweep { (cd $SFDIR; /usr/bin/sweep $@) }
function   ssm { (cd $SFDIR; /usr/bin/SpiralSynthModular $@) }
function   wavesurfer { (cd $SFDIR; /usr/bin/wavesurfer $@) }
function   bounce { (cd $SFDIR; /usr/local/bin/bounce $@) } 
function   normalize { (cd $SFDIR; /usr/bin/normalize $@) }
function   gtoaster { (sudo /usr/bin/gtoaster $@) }
#
# --- JACK audio connection kit ---
#
function   jack { (/usr/bin/jackd  -d alsa -d hw:0 -r 44100 -H -M -p 1024 $@) }
function   jackstart { (/usr/bin/jackstart  -d alsa -d hw:0 -r 44100 -H -M -p 1024 $@) }
function   jack96 { (/usr/bin/jackd  -d alsa -d hw:0 -r 96000 -H -M -p 1024 $@) }
function   jackstart96 { (/usr/bin/jackstart  -d alsa -d hw:0 -r 96000 -H -M -p 1024 $@) }
function   jack48 { (/usr/bin/jackd -d alsa -d hw:0 -r 48000 -H -M -p 1024 $@) }
function   jackstart48 { (/usr/bin/jackstart -d alsa -d hw:0 -r 48000 -H -M -p 1024 $@) }
function   qjackconnect { (/usr/bin/qjackconnect $@) }
function   qj { (/usr/bin/qjackconnect $@) }
function   qjc { (/usr/bin/qjackctl $@) }
function   ardour { (cd $SFDIR; /usr/bin/ardour $@) }
function   zynaddsubfx { (cd $SFDIR; /usr/bin/zynaddsubfx $@) }
function   fx { (cd $SFDIR; /usr/bin/zynaddsubfx $@) }
function   meters { (/usr/bin/meterbridge -t vu  alsa_pcm:capture_1 alsa_pcm:capture_2 alsa_pcm:playback_1 alsa_pcm:playback_2 $@) }
function   scopes { (/usr/bin/meterbridge -t sco  alsa_pcm:capture_1 alsa_pcm:capture_2 alsa_pcm:playback_1 alsa_pcm:playback_2 $@) }
function   digimeters { (/usr/bin/meterbridge -t dpm  alsa_pcm:capture_1 alsa_pcm:capture_2 alsa_pcm:playback_1 alsa_pcm:playback_2 $@) }
function   freqtweak { (cd $SFDIR; /usr/bin/freqtweak $@) }
function   ft { (cd $SFDIR; /usr/bin/freqtweak $@) }
function   jarecord { (cd $SFDIR; /usr/bin/qarecord --jack $@) }
function   qarecord { (cd $SFDIR; /usr/bin/qarecord $@) }
function   ecasound { (cd $SFDIR; /usr/bin/ecasound $@) }
function   rezound { (cd $SFDIR; /usr/bin/rezound --audio-method=jack $@) }
function   jpd { (/usr/bin/pd -jack $@) }
#
# --- ECMC play/record aliases and programs ---
#
function   fplay { shopt -u -o noglob; (cd $SFDIR; /usr/local/bin/play $@) } 
alias  play='shopt -s -o noglob; fplay' # override /usr/bin/play with ECMC script
#function   p { (cd $SFDIR; /usr/local/bin/play $@) }
alias p='shopt -s -o noglob; fplay'

function fjplay { shopt -u -o noglob; ( cd $SFDIR; /usr/local/bin/jplay $@ 2> /dev/null) }
alias jplay='shopt -s -o noglob; fjplay'
alias jp='shopt -s -o noglob; fjplay'

function   frecord { shopt -u -o noglob; (cd $SFDIR; /usr/bin/arecord -D mon_mix -f cd $@) }
alias record='shopt -s -o noglob; frecord'
alias r='shopt -s -o noglob; frecord'

function   frecord96 { shopt -u -o noglob; (cd $SFDIR; /usr/bin/arecord -D mon_mix -c 2 -f S32_LE -r 96000 $@) }
alias record96='shopt -s -o noglob; frecord96'
alias r96='shopt -s -o noglob; frecord96'

#function   r { (cd $SFDIR; /usr/bin/arecord -D mon_mix -f cd $@) }
#function   r96 { (cd $SFDIR; /usr/bin/arecord -D mon_mix -c 2 -f S32_LE -r 96000 $@) }

function   fsndinfo { shopt -u -o noglob; (cd $SFDIR; /usr/bin/sndinfo $@) }  # Schottstedt ccrma sndinfo
alias sndinfo='shopt -s -o noglob; fsndinfo'

function   fsfinfo { shopt -u -o noglob; (cd $SFDIR; /usr/local/bin/sfinfo $@) }
alias sfinfo='shopt -s -o noglob; fsfinfo'
alias si='shopt -s -o noglob; fsfinfo'

#function   si { (cd $SFDIR; /usr/local/bin/sfinfo $@) }
function   sfnorm { (cd $SFDIR; /usr/local/bin/sfnorm $@) }


function   stripnorm { (cd $SFDIR; /usr/local/bin/stripnorm $@) }
#
# --- aliases for the sflib partitions  ---
function   lsflib { (cd $SFLIB; ls -h $@) } # list sflib soundfiles
function   lsfl { (cd $SFLIB; ls -h $@) } # list sflib soundfiles
function   lsflib96 { (cd $SFLIB96; ls -h $@) } # list sflib soundfiles
function   lsfl96 { (cd $SFLIB96; ls -h $@) } # list sflib soundfiles
function   sfli { (/usr/local/bin/sflibinfo $@) } # list sflib soundfiles
function   sfli96 { (/usr/alocal/bin/sflibinfo $@) } # list sflib soundfiles
function   psfl { (playsflib $@) }
function   psflib { (playsflib $@) }
#
# --- Csound aliases and programs --- 
# all csound aliases relative to the CSOUND environment variable path at top
# ??? export CSND /usr/bin/csound
export SSDIR=/snd/`whoami`
export SADIR=$SFDIR
function   csound { ($CSDIR/csound -W -R $@) }   # write WAV soundfile
function   cs { ($CSDIR/csound -W -R $@) }   # write WAV soundfile
function   csound64 { ($CSDIR/csound64 -W -R $@) }   # use 64 bit processing
function   cs64 { ($CSDIR/csound64 -W -R $@) }   # use 64 bit processing
function   csndinfo { (cd $SFDIR; csound -U sndinfo -R $@) }
# needed for cecilia
function   cecilia { (cd $SFDIR; /usr/bin/cecilia $@ ) }
function   cec { (cd $SFDIR; /usr/bin/cecilia $@) }
export CEC_LIBRARY=/usr/lib/cecilia
export MODIR=/usr/lib/cecilia/files/ECMC
function   envext { (cd $SFDIR; $CSDIR/envext $@) }  
function   scale { (cd $SFDIR; $CSDIR/scale $@) }
function   mixer { (cd $SFDIR; $CSDIR/mixer $@) }
function   srconv { (cd $SFDIR; $CSDIR/srconv $@) }
function   sdif2ad { (cd $SFDIR; $CSDIR/sdif2ad $@) }  
function   cvanal { (cd $SFDIR; $CSDIR/cvanal $@) }
function   dnoise { (cd $SFDIR; $CSDIR/dnoise $@) }
function   lpanal { (cd $SFDIR; $CSDIR/lpanal $@) }
function   lpcanal { (cd $SFDIR; $CSDIR/lpanal $@) }
# alias	lpdump='(cd $SFDIR; $CSDIR/lpdump )'
function   hetro { (cd $SFDIR; $CSDIR/hetro $@) }
function   pvanal { (cd $SFDIR; $CSDIR/pvanal $@) }
function   pvlook { (cd $SFDIR; $CSDIR/pvlook $@) }
# ECMC csound aliases
function   csplay { (usr/local/bin/csoundplay $@) }
function   csp { (/usr/local/bin/csoundplay $@) }
function   csmidiplay { (/usr/local/bin/csoundmidiplay $@) }
function   csmp { (/usr/local/bin/csoundmidiplay $@) }
 # directory of tutorial orc/sco pairs  that comes bundled with some Csound distros:
function   csoundexamples { (cd /usr/local/lib/csoundexamples $@; echo "You are now in directory >> `pwd` <<") }
#
#
# --- ECMC Csound Library ---
#
function   lscsl { (lscslib $@) }
function   lscslibins { (/usr/local/bin/lsins $@) }
function   lstpsc { (lstp sc $@) }
function   lsmidifuncs { (ls $CSLIBDIR/midifuncs $@) }
function   lsmidiins { (ls $CSLIBDIR/midiins $@) }
function   getfunc { (getcsfunc $@) }
function   getfuncs { (getcsfunc $@) }
function   getmidisc { (getmidiscore $@) }
function   getmidifuncs { (getmidifunc $@) }
function   mkcsmidiplay { (mkcsoundmidiplay $@) }
function   mkcsmp { (mkcsoundmidiplay $@) }
function   mkorch { (/usr/local/bin/mko $@) }
function   mkorc { (/usr/local/bin/mko $@) }
function   m4o { (m4orch $@) }
function   mkmidiorc { (/usr/local/bin/mkmidiorch $@) }
function   mkmidio { (/usr/local/bin/mkmidiorch $@) }
function   lsfuncs { (/usr/local/bin/lsfunc $@) }
function   sflinksfl { (sflinksflib $@) }
# DEPRECATED legacy commands and aliases : it should be possible to
# delete all of these in late 2004 after all ECMC documentation has been
# cleaned up to reflect 2004 revisions
# Deprecated old commands/aliases but redirected for now:
function   lssc { (echo  The command [ lssc ] has been replaced by [ lstp sc ] : Running lstp sc for you:; sleep 1 ;  lstp sc $@) }
function   getsc { (sctp $@) }  # legacy alias
function   getscore { (sctp $@) } # legacy alias
function   getcsscore { (sctp $@) }  # legacy alias
function   lsolibins { (echo  The command [ lsolibins ] has been replaced by [ lsins ] : Running lsins for you:; sleep 1 ;  lsins $@) }
function   lsolibex { (echo " The command [ lsolibex ] has been replaced by [ lsex sc ] : Running lsex sc for you:"; sleep 1 ;  lsex $@) }
function   getscx { (sctpx $@) }
function   getscxsynpitch { (sctpxsynpitch $@) }
function   getsclpcpitch { (sctplpcpitch $@) }
function   getscgxsynpitch { (sctpgxsynpitch $@) }
     # Deprecated, no longer used/supported:
# DEPRECATED alias   getcslibex=getex
# DEPRECATED alias	lsolibfuncs=lsolibfunc
# DEPRECATED alias   lsdoc=lsolibdoc
# DEPRECATED alias   getdoc=getolibdoc
# --- PVC ---
#
function   plainpvtp { ($PVCDIR/TKLA/plainpvtp $@) }
function   pvcanal { ($PVCBIN/pvanalysis $@) }
function   pvanalysistp { ($PVCDIR/TKLA/pvanalysistp $@) } 
function   pvcanaltp { ($PVCDIR/TKLA/pvanalysistp $@) }
function   twarptp { ($PVCDIR/TKLA/twarptp $@) }
function   convolvertp { ($PVCDIR/TKLA/convolvertp $@) }
function   chordmappertp { ($PVCDIR/TKLA/chordmappertp $@) }
function   harmonizertp { ($PVCDIR/TKLA/harmonizertp $@) }
# DEPRECATED legacy pvc commands and aliases : it should be possible to
# delete all of these in late 2004 after all ECMC documentation has been
# cleaned up to reflect 2004 revisions
function   lspvcex { (lsex pvc $@) }  # deprecated -- eventually delete
function   pvcex { (lsex pvc $@) }  # deprecated -- eventually delete
function   pvctp { (lstp pvc $@) }    # deprecated -- eventually delete
#
# --- SMS  -- no current SMS aliases

# --- VSPACE ---
#
function   vspace { (/usr/local/bin/ecmcvspace $@) }
function   vspace48 { (/usr/local/bin/ecmcvspace48 $@) }
function   vspace96 { (/usr/local/bin/ecmcvspace96 $@) }
function   ambidec { (cd $SFDIR; /usr/local/bin/ambidec $@) }
function   ambidec48 { (cd $SFDIR; /usr/local/bin/ambidec48 $@) }
function   ambidec96 { (cd $SFDIR; /usr/local/bin/ambidec96 $@) }
# DEPRECATED legacy vspace commands and aliases : delete when all vspace
# documentation has been corrected to reflect 2004 command name revisions
function   lsvspacex { (lsex vs $@) }
function   getvspacex { (getex vs $@) }
#

# --- CD burning ---
function   k3b { (/usr/bin/k3b) }
function   mkaudiocd { (cd $SFDIR; /usr/local/bin/mkaudiocd $@) }
function   burnaudiocd { (cd $SFDIR; /usr/local/bin/burnaudiocd $@) }
function   blankcdr { (sudo cdrecord -v dev=$CDR_DEVICE speed=$CDR_SPEED blank=disk) }
function   blankcdrw { (sudo cdrecord -v dev=$CDR_DEVICE speed=$CDR_SPEED blank=disk) }
function   blankcdrq { (sudo cdrecord -v dev=$CDR_DEVICE speed=$CDR_SPEED blank=fast) }
function   blankcdrwq { (sudo cdrecord -v dev=$CDR_DEVICE speed=$CDR_SPEED blank=fast) }
function   cdparanoia { (cd $SFDIR; /usr/bin/cdparanoia $@) }
function   cdpar { (cd $SFDIR; /usr/bin/cdparanoia $@) }
function   cdrecordd { (sudo cdrecord -v dev=$CDR_DEVICE speed=$CDR_SPEED driveropts=burnfree -data $@) }
function   cdrecorda { (cd $SFDIR ; sudo cdrecord -v dev=$CDR_DEVICE speed=$CDR_SPEED driveropts=burnfree -audio $@) }
#
# --- CDROM access/ripping
#
function   cdinfo { ( /usr/bin/cdparanoia -Q) }
function   lscd { (cd /mnt/cdrom ; ls -h $@) }
function   cdrip { (cd $SFDIR ; cdparanoia -v -w -B $@) }
function   cdplay { ( cdda2wav -D /dev/cdrom  -g -eN -x -t $@) }
function   pcd { (cdda2wav -D /dev/cdrom  -g -eN -x -t $@) }
function   playcd { (cdda2wav -D /dev/cdrom  -g -eN -x -t $@) }
#
# --- Secure Networking (soundfile dir) may need editing for local systems --
function  scpsf { (cd $SFDIR; /usr/bin/scp $@) }
# Currently not working: alias	ecmcputsf='(cd $SFDIR; /usr/local/bin/ecmcputsf )' 
# Currently not working: alias	ecmcgetsf='(cd $SFDIR; /usr/local/bin/ecmcgetsf )'
# Currently not working: alias	ecmcputsf.cvt='(cd $SFDIR; /usr/local/bin/ecmcputsf.cvt )'
# Currently not working: alias	ecmcgetsf.cvt='(cd $SFDIR; /usr/local/bin/ecmcgetsf.cvt )'

function   sshd 	{ (ssh -Y digital.music.cornell.edu) }
function   sshb27 	{ (ssh -Y b27.music.cornell.edu) }
function   sshb25b 	{ (ssh -Y b25b.music.cornell.edu) }
function   sshb25c 	{ (ssh -Y b25c.music.cornell.edu) }
function   sshb25d 	{ (ssh -Y b25d.music.cornell.edu) }

# Editors for Mac OSX

function textedit { (/Applications/Smultron.app/Contents/MacOS/Smultron siren.sco &> /dev/null $@) }
function edit { (/Applications/Smultron.app/Contents/MacOS/Smultron siren.sco &> /dev/null $@) }
function tedit { (/Applications/Smultron.app/Contents/MacOS/Smultron siren.sco &> /dev/null $@) }
function te { (/Applications/Smultron.app/Contents/MacOS/Smultron siren.sco &> /dev/null $@) }

######## BROKEN apps currently not working:
# alias	mix='(cd $SFDIR; /usr/X11R6/bin/mix )'
# alias	shorten='(cd $SFDIR; /usr/bin/shorten )'
# alias	runsfcompress='(cd $SFDIR; /usr/local/bin/runsfcompress )'
# alias	runsfuncompress='(cd $SFDIR; /usr/local/bin/runsfuncompress )'
#end
### DEPRECATED ########################
## REPLACED BY SCRIPT 9/14/04 function   sfpeak { (cd $SFDIR; /usr/local/bin/sndpeak $@) }
## REPLACED BY SCRIPT 9/14/04 function   sndpeak { (cd $SFDIR; /usr/local/bin/sndpeak $@) }
function   lsvspacex { (lsex vs $@) } # deprecated
