COMMENT lpcptrack.h : pass lpc file pitch track (ptrack) data from
COMMENT "xsyn", "gxsyn" or "lpcpitch" module to Library instruments and substitute it
COMMENT for the instrument's internal pitch generation k-rate variable
COMMENT   lpc pitch track definitions for use with "xsyn"::
include(CSLIBDIR/Include/lpcpitch_defs) COMMENT get p-field macros & numbers
ifelse(PTSOURCE,1,[define([XSYNREAD],[
; ### Xsyn Pitch Track Insert : READ IN LP.M FILE  ###
if PAR3 < 0 igoto xsyntables
	ix3 = (PAR3 = 0 ? p3-PAR2 : PAR3)    ; default dur. is p3-PAR2
	ix4 init PAR2
	igoto doit
xsyntables: ix4 table abs(PAR3), 96          ; f96 is table of skips (PAR2 ignored)
	ix3 table abs(PAR3), 97          ; f97 is table of durs.
	igoto doit
doit:   ktime	line  ix4, p3, ix3
krmsr,krmso,kerr,kptrack	lpread	ktime, PAR1
; TRANSPOSE FORMANTS
; ix5 = transposition of formant frequencies 
ix5 init 1
if PAR4 = 0 goto transpose   ; no formant change
	if PAR4 = 2 igoto fmtoffset
		; if PAR4 = 1, PAR5 = multiplier for formant freqs.
		; (should not be > 2.3 or < .4)
		ix5 = PAR5
		igoto transpose
	fmtoffset: ; if PAR4 = 2, PAR5 = semitone (int.) & microtonal (frac.)
		  ; transposition of formants
		ix6 init 0
		ix5 init 1
		doitagain: ix6 = ix6 + 1
	     	     ix7 = (PAR5 > 0 ? 1.05946 : .94387);1/2 step freq. ratios
		     ix1 = (int(PAR5) = 0 ? 1 : ix7)
		     ix5 = ix5 * ix1
		     ix8 = abs(PAR5)
		if ix6 < int(ix8) igoto doitagain
		ix9 = ix7 - 1  ; microtonal offset
		     ix9 = frac(ix8) * ix9
		     ix5 = ix5 + ix9
transpose: ; TRANSPOSE KPTRACK (or gkptrack)
;if PAR14 = 0, PAR15 = multiplier for ptrack pitch
;if PAR14 = 1, PAR15 = semitone & microtone transposition for ptrack pitch
;if PAR14 = 2, PAR15 = ignored. Pitch transposition = formant transp.(PAR4,PAR5)
; if PAR14 is negative, ptrack not used. Instrument p4 pitch used instead
if PAR14 > 0 goto case2
if PAR14 < 0 goto gotpitch ; if PAR14 = -1, or negative, ptrack pitch not used
	; if PAR14 = 0, pitch = PAR15 * kptrack (from ptrack analysis file)
	PAR15 = (PAR15=0 ? 1 : PAR15)
	kpitch = kptrack * PAR15
	goto gotpitch
case2:	if PAR14 > 1 goto case3
 ; if PAR14 = 1, int (PAR15) = semitone freq. offset, frac (PAR15) = microtonal offset
	ipt1 init 0
	ipt2 init 1.
	ptloop:   ; stupid loop, but it works
	      ipt1 = ipt1+1   ; counter
	      ipt3 =  (PAR15 > 0 ? 1.05946 : .94387) ; 1/2 step freqency ratios
	      ipt4 = (int(PAR15) = 0 ? 1 : ipt3)
	      ipt2 = ipt2*ipt4  ; multiplier for kcps
	      ipt5 = abs(PAR15)
	      if ipt1 < int(ipt5) igoto ptloop
        ipt6 = ipt3-1           ; microtonal frequency offset
	ipt6 = frac(ipt5) * ipt6
	ipt2 = ipt2 + ipt6        ; add microtonal frequency ratio, if any
	kpitch = kptrack * ipt2
	goto gotpitch
case3: kpitch = kptrack * ix5 ; formant transposition applied to pitch as well
gotpitch:   
; ##### end of xsyn read, formant & pitch transposition insert ####
])])dnl
COMMENT ptack definitions for use with "gxsyn":
ifelse(PTSOURCE,2,[define([GXSYNPITCH],[
; gkptrack pitch read-in from instrument Gxsyn with possible transposition
; if gxsynPitchFlag = 0, gxsynPitchTransp = multiplier for gkptrack pitch
; if gxsynPitchFlag = 1, gxsynPitchTransp = semitone & microtone 
                   ; transposition for gkptrack pitch
; if gxsynPitchFlag = 2,gxsynPitchTransp = ignored. Pitch transp. = Gxsyn formant transp.
; if gxsynPitchFlag is negative, gkptrack not used. Instrument p4 pitch used instead

if gxsynPitchFlag > 0 goto case2
if gxsynPitchFlag < 0 goto gotpitch ; if gxsynPitchFlag = negative (1),ptrack pitch not used
    ; if gxsynPitchFlag = 0, pitch = gxsynPitchTransp * gkptrack (from ptrack analysis file)
	gxsynPitchTransp = (gxsynPitchTransp=0 ? 1 : gxsynPitchTransp)
	kpitch = gkptrack * gxsynPitchTransp
	goto gotpitch
case2:	if gxsynPitchFlag > 1 goto case3
 ; if gxsynPitchFlag = 1, int (gxsynPitchTransp) = semitone freq. offset,
                   ;  fraction (gxsynPitchTransp) = microtonal offset
	ipt1 init 0
	ipt2 init 1.
	ptloop:   ; stupid loop, but it works
	      ipt1 = ipt1+1   ; counter
	      ipt3 = (gxsynPitchTransp > 0 ? 1.05946 : .94387) ; 1/2 step freq. ratios
	      ipt4 = (int(gxsynPitchTransp) = 0 ? 1 : ipt3)
	      ipt2 = ipt2*ipt4  ; multiplier for kcps
	      ipt5 = abs(gxsynPitchTransp)
	      if ipt1 < int(ipt5) igoto ptloop
        ipt6 = ipt3-1           ; microtonal frequency offset
	ipt6 = frac(ipt5) * ipt6
	ipt2 = ipt2 + ipt6        ; add microtonal frequency ratio, if any
	kpitch = gkptrack * ipt2
	goto gotpitch
case3:   ; Gxsyn formant transposition applied to pitch
	kpitch = gkptrack * gifrmtshift
gotpitch:   
; ##### end of gxsyn gkptrack pitch read & pitch transposition insert ####
])])dnl
ifelse(PTSOURCE,0,[define([PTREAD],[
; ### lpc  pitch track insert : READ IN LP.M FILE  ###
define([lpcLink],[PAR1])dnl
define([lpcBegRead],[PAR2])dnl
define([lpcEndREad],[PAR3])dnl
define([lpcPitchFlag],[PAR4])dnl
define([lpcPitchTransp],[PAR5])dnl
; lpcLink : lp.#
; lpcBegRead : time in lp.m file to begin reading
; lpcEndRead :  "    "    "    "    end  "  " , or index to functions 96 & 97
;    if lpcEndRead = 0, it has the value of p3 - lpcBegRead (read to end of lp.m)
;    if lpcEndRead is negative, it specifies the index to function tables 96 & 97
;     but start with location 1 (not 0) in these tables
; lpcPitchFlag : method of ptrack pitch transposition , or bypass ptrack for this note
; lpcPitchTransp : pitch multiplier or transposition

if lpcEndRead < 0 igoto lpctables
 ix3 = (lpcEndRead = 0 ? p3-lpcBegRead : lpcEndRead) ; default dur. is p3-lpcBegRead
	ix4 init lpcBegRead
	igoto doit
lpctables: ix4 table abs(lpcEndRead), 96 ; f96 is table of skips (lpcBegRead ignored)
	ix3 table abs(lpcEndRead), 97 ; f97 is table of surs.
	igoto doit
doit:   ktime	line  ix4, p3, ix3
krmsr,krmso,kerr,kptrack	lpread	ktime, lpcLink
; KPTRACK TRANSPOSITION
;if lpcPitchFlag = 0, lpcPitchTransp = multiplier for ptrack pitch
;if lpcPitchFlag = 1, lpcPitchTransp = semitone & microtone transposition for ptrack pitch
; if lpcPitchFlag is negative, ptrack not used. Instrument p4 pitch used instead

if lpcPitchFlag > 0 goto case2
if lpcPitchFlag < 0 goto gotpitch ; if lpcPitchFlag = -1, or negative, ptrack pitch not used
      ; if lpcPitchFlag = 0, pitch = lpcPitchTransp * kptrack (from ptrack analysis file)
	lpcPitchTransp = (lpcPitchTransp=0 ? 1 : lpcPitchTransp)
	kpitch = kptrack * lpcPitchTransp
	goto gotpitch
case2:
 ; if lpcPitchFlag = 1, int (lpcPitchTransp) = semitone freq. offset,
 ;   fraction (lpcPitchTransp) = microtonal offset
	ipt1 init 0
	ipt2 init 1.
	ptloop:   ; stupid loop, but it works
	    ipt1 = ipt1+1   ; counter
	    ipt3 =  (lpcPitchTransp > 0 ? 1.05946 : .94387) ; 1/2 step freqency ratios
	    ipt4 = (int(lpcPitchTransp) = 0 ? 1 : ipt3)
	    ipt2 = ipt2*ipt4  ; multiplier for kcps
	    ipt5 = abs(lpcPitchTransp)
	    if ipt1 < int(ipt5) igoto ptloop
        ipt6 = ipt3-1           ; microtonal frequency offset
	ipt6 = frac(ipt5) * ipt6
	ipt2 = ipt2 + ipt6        ; add microtonal frequency ratio, if any
	kpitch = kptrack * ipt2
	goto gotpitch
gotpitch:   
; #### end of lpcpitch insert ####
])])dnl
define([PTINSERT],[ifelse(PTSOURCE,1,[XSYNREAD],PTSOURCE,2,[GXSYNPITCH],
[PTREAD])])dnl
PTINSERT
