COMMENT xsyndefs.o.h
COMMENT include(CSLIBDIR/Include/pt.h)
include(CSLIBDIR/Include/lpcpitch_defs)
define([XSYNPARAMS],[
; PAR1  lp.m#
; PAR2  time in orig. s.f. to begin read-in
; PAR3  time in orig. s.f. to end read-in ;
;     if 0 = p3 - PAR2
;     if neg. = index to tables 96 & 97, but DO NOT USE  0 (start with -1)
; OPTIONAL PARAMETERS :
; PAR4 & PAR5 : formant frequencies transposition: if PAR4 = 0, no change
;    if PAR4 = 1, PAR5 = multiplier for formants; if PAR4 = 2, PAR5 = semitone
;    (integer portion) and/or microtonal (frac) transposition of formants
; PAR6 and PAR7 Brightness modifiers; if PAR6 = 0, no modification;
;    if PAR6 = 1, ptrack pitch used for filter cutoffs
;    and other value for PAR6 = filter cutoff freq., in pch or cps
;    PAR7  brightness modifier, from -1 (least bright) to +1 (brightest)
; PAR8 Add white noise : if 0 no noise added
;     if positive between .001 & 1., specifies constant % noise added to driver
;     if negative, specifies minimum % noise added during completely periodic
;     analysis frames (kerr = 0). Progressively greater amounts of noise are
;     added, up to 100% of driver amplitude, as kerr approaches .3
; PAR9 determines the amplitude envelope; if 0, envelope of lp.m file is used;
;       if -1, internal mixture of lp.m envelope & driver envelope
;       if between .001 and +1. , a mix of the lp.m file & driver envelopes is
;       used, and PAR9 specifies the % of the driver envelope
; PAR10 = amplitude multiplier
; PAR11 fade-in time;  PAR12  fade-out time (zeros are ok)
; PAR13 Attack hardness ; 0 = no change ; Range : -1 (greatest smoothing of
;       attack) to +1. (hardest attack)
; PAR14 = pan location for STEREO output only
])dnl
ifelse(PTSOURCE,1,,[define([XSYNREAD],[
; READ IN LP.M FILE, TRANSPOSE FORMANTS
if PAR3 < 0 igoto xtables
	ix3 = (PAR3 = 0 ? p3-PAR2 : PAR3)    ; default dur. is p3-PAR2
	ix4 init PAR2
	igoto doit
xtables: ix4 table abs(PAR3), 96          ; f96 is table of skips (PAR2 ignored)
	ix3 table abs(PAR3), 97          ; f97 is table of surs.
	igoto doit
doit:   ktime	line  ix4, p3, ix3
krmsr,krmso,kerr,KPTRACK	lpread	ktime, PAR1
; TRANSPOSE FORMANTS
; ix5 = transposition of formant frequencies 
ix5 init 1
if PAR4 = 0 goto driver   ; no formant change
	if PAR4 = 2 igoto fmtoffset
		; if PAR4 = 1, PAR5 = multiplier for formant freqs.
		; (should not be > 2.3 or < .4)
		ix5 = PAR5
ifelse(PTSOURCE,2,[;formant shift value available as global variable for driver pitch shift
		gifrmtshift = ix5])
		igoto driver
	fmtoffset: ; if PAR4 = 2, PAR5 = semitone (int.) & microtonal (frac.)
		  ; transposition of formants
		ix6 init 0
		ix1 init 1
		doitagain: ix6 = ix6 + 1
	     	     ix7 = (PAR5 > 0 ? 1.05946 : .94387);1/2 step freq. ratios
		     ix10 = (int(PAR5) = 0 ? 1 : ix7)
		     ix5 = ix1 * ix10
		     ix8 = abs(PAR5)
		if ix6 < int(ix8) igoto doitagain
		ix9 = ix7 - 1  ; microtonal offset
		     ix9 = frac(ix8) * ix9
		     ix5 = ix5 + ix9
ifelse(PTSOURCE,2,[;formant shift value available as global variable for driver pitch shift
		gifrmtshift = ix5])
])])dnl
define([XSYNBODY],[
driver: asig = DRIVER
aorig = DRIVER
DRIVER = 0
if krmso = 0 kgoto xsynout ;skip synthesis during silences in lp.m file
; Amplitude (PAR10) and Attack Hardness (PAR13)
	PAR10 = (PAR10 = 0 ? 1. : PAR10)
	ix15 = (PAR10 + 1)/2
		PAR13 = (PAR13 > 1. ? 1. : PAR13)   ; protections against
		PAR13 = (PAR13 < -1. ? -1. : PAR13) ; user score errors
      ixatthard = PAR13 * .033
      ixatthard = (ixatthard < 0 ? ixatthard * 2 : ixatthard) ; maximum fade-in
      ixattacktime = .033 - ixatthard              ; when PAR13 = -1 is .099 "
		;  kampscale: to reduce exaggerated attack of krmso
		;   and allow PAR10 to affect internal signal processing level
	kampscale linseg 0, ixattacktime, ix15 , p3 , ix15
	krmso = krmso * kampscale

; ADD WHITE NOISE SOURCE :
if PAR8 = 0 goto res   ; no noise added if PAR8 = 0
	knoise  rms asig
	anoise  rand  knoise
	if PAR8 < 0 goto varynoisepct
		; if PAR8 is positive, it specifies constant % of added noise
		asig = asig + (PAR8 * anoise)
		goto res
	varynoisepct: ; if PAR8 is negative, it specifies lowest % noise added
		    ; when kerr = 0. 
                    ; Noise % increase with kerr, up to 100 % when kerr = .3
		inoisefloor = abs(PAR8)
		idiff = 1. - inoisefloor
		kdiff = (.3 - kerr) * 3.33
		kdiff = (kdiff < 1. - inoisefloor? kdiff : 1. - inoisefloor)
		knoisepct = inoisefloor + (kdiff * idiff)
		asig = asig + (knoisepct * anoise)
res:   asig  lpfreson  asig,ix5
; ENVELOPE :
	; when PAR9 = -1, mix of lp.m & driver envelopes results:
if PAR9 < 0 goto brightness  
if PAR9 > 0 goto envmix
		; if PAR9 = 0, lp.m file envelope is used:
		asig gain  asig, krmso
		goto brightness
	envmix:   ; if PAR9 between .001 & 1., mix of driver & lp.m envelopes
		  ; PAR9 specifies % driver envelope
		asig2  gain asig, krmso  ; lp.m envelope
		asig1  balance asig, aorig
		asig = (PAR9 * asig1) + ((1 - PAR9) * asig2)
brightness: ; BRIGHTNESS
if PAR6 = 0 goto fade
	ihi = PAR7+1
	ilo = (2 - ihi)
	ix12 = (ihi + 1)/2
	if PAR6 != 1 goto newcenterfreq
		kcenfreq = KPTRACK  ;when PAR6 = 1, ptrack pitch used
		kcenfreq = ix12 * kcenfreq
		goto xsynbrightness
	newcenterfreq:   ; if PAR6 != 1 or 0, it = new filter center freq.
		icenfreq = (PAR6 < 13.0 ? cpspch(PAR6) : PAR6)
		kcenfreq = icenfreq
xsynbrightness:
	asiglo reson  .5*asig, ix12 * kcenfreq, ix12 * 1.5 * kcenfreq , 1
	asighi areson .5*asig, ix12 * kcenfreq, ix12 * 1.5 * kcenfreq , 1
	asig balance (ihi * asighi) + (ilo * asiglo), asig
fade:   ; FADE-IN & FADE-OUT :
	PAR10 = (PAR10 = 0 ? 1. : PAR10)
	PAR11 = (PAR11 = 0 ? .0001 : PAR11)
	PAR12 = (PAR12 = 0 ? .0001 : PAR12)
	kfade  expseg  .005, PAR11, PAR10, p3 - (PAR11+PAR12), PAR10, PAR12 , .005
	a1 = asig * kfade
xsynout: ])dnl
